/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.MarkupData;

public class DealMarkup {
    public ItemStack main = ItemStack.field_190927_a;
    public int count = 0;
    public final Map<ItemStack, Integer> baseItems = new LinkedHashMap<ItemStack, Integer>();
    public Map<ItemStack, Integer> buyItems = new LinkedHashMap<ItemStack, Integer>();
    public Map<ItemStack, Integer> sellItems = new LinkedHashMap<ItemStack, Integer>();
    public final Map<ItemStack, Boolean> baseHasPlayerItems = new LinkedHashMap<ItemStack, Boolean>();
    public Map<ItemStack, Boolean> buyHasPlayerItems = new LinkedHashMap<ItemStack, Boolean>();
    public Map<ItemStack, Boolean> sellHasPlayerItems = new LinkedHashMap<ItemStack, Boolean>();
    public long baseMoney = 0L;
    public long buyMoney = 0L;
    public long sellMoney = 0L;
    public boolean baseOneOfEach = true;
    public boolean buyOneOfEach = true;
    public boolean sellOneOfEach = true;
    public boolean ignoreNBT = false;
    public boolean ignoreDamage = false;
    public Deal deal = null;

    public void check(NonNullList<ItemStack> inventory) {
        this.baseHasPlayerItems.clear();
        this.buyHasPlayerItems.clear();
        this.sellHasPlayerItems.clear();
        for (ItemStack stack : this.baseItems.keySet()) {
            int count = 0;
            for (ItemStack s : inventory) {
                if (NoppesUtilServer.IsItemStackNull(s) || !NoppesUtilPlayer.compareItems(stack, s, this.ignoreDamage, this.ignoreNBT)) continue;
                count += s.func_190916_E();
            }
            this.baseHasPlayerItems.put(stack, count >= this.baseItems.get(stack));
            this.buyHasPlayerItems.put(stack, this.buyItems.containsKey(stack) && count >= this.buyItems.get(stack));
            this.sellHasPlayerItems.put(stack, this.sellItems.containsKey(stack) && count >= this.sellItems.get(stack));
        }
        this.buyOneOfEach = true;
        Iterator<Object> iterator = this.buyItems.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 1) continue;
            this.buyOneOfEach = false;
            break;
        }
        this.sellOneOfEach = true;
        iterator = this.sellItems.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 1) continue;
            this.sellOneOfEach = false;
            break;
        }
    }

    public void reset(boolean isBuy, float coff) {
        if (!this.baseItems.isEmpty()) {
            for (ItemStack stack : this.baseItems.keySet()) {
                int count = (int)((float)this.baseItems.get(stack).intValue() * coff);
                if (count <= 0) {
                    count = 1;
                }
                if (isBuy) {
                    this.buyItems.put(stack, count);
                    continue;
                }
                this.sellItems.put(stack, count);
            }
        }
        for (ItemStack stack : this.buyItems.keySet()) {
            if (this.buyItems.get(stack) <= 1) continue;
            if (isBuy) {
                this.buyOneOfEach = false;
                break;
            }
            this.sellOneOfEach = false;
            break;
        }
        if (isBuy) {
            this.buyMoney = (long)((float)this.baseMoney * coff);
        } else {
            this.sellMoney = (long)((float)this.baseMoney * coff);
        }
        if (this.buyMoney <= 0L && this.baseMoney > 0L) {
            this.buyMoney = 1L;
        }
        if (this.sellMoney <= 0L && this.baseMoney > 0L) {
            this.sellMoney = 1L;
        }
    }

    public void set(Deal deal) {
        this.deal = deal;
        this.main = deal.getProduct().getMCItemStack().func_77946_l();
        this.count = deal.getProduct().getStackSize();
        this.ignoreNBT = deal.getIgnoreNBT();
        this.ignoreDamage = deal.getIgnoreDamage();
        this.baseMoney = deal.getMoney();
        this.set(deal.getMCInventoryCurrency());
    }

    public void set(IInventory inventory) {
        this.baseItems.clear();
        if (inventory == null || !inventory.func_191420_l()) {
            HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
            for (int slot = 0; slot < Objects.requireNonNull(inventory).func_70302_i_(); ++slot) {
                ItemStack stack = inventory.func_70301_a(slot);
                if (NoppesUtilServer.IsItemStackNull(stack)) continue;
                boolean bl = false;
                for (ItemStack s : map.keySet()) {
                    if (!NoppesUtilPlayer.compareItems(stack, s, this.ignoreDamage, this.ignoreNBT)) continue;
                    bl = true;
                    map.put(s, (Integer)map.get(s) + stack.func_190916_E());
                    this.baseOneOfEach = false;
                    break;
                }
                if (bl) continue;
                map.put(stack, stack.func_190916_E());
                if (stack.func_190916_E() <= 1) continue;
                this.baseOneOfEach = false;
            }
            ArrayList list = new ArrayList(map.entrySet());
            list.sort((st_0, st_1) -> ((Integer)st_1.getValue()).compareTo((Integer)st_0.getValue()));
            for (Map.Entry entry : list) {
                this.baseItems.put((ItemStack)entry.getKey(), (Integer)entry.getValue());
            }
        }
    }

    public void set(MarkupData md) {
        if (md == null) {
            return;
        }
        this.buyItems.clear();
        this.sellItems.clear();
        this.buyMoney = this.baseMoney;
        this.sellMoney = this.baseMoney;
        if (md.buy != 0.0f) {
            this.reset(true, (100.0f + md.buy * 100.0f) / 100.0f);
        } else {
            for (ItemStack stack : this.baseItems.keySet()) {
                this.buyItems.put(stack, this.baseItems.get(stack));
            }
        }
        if (md.sell != 0.0f) {
            this.reset(false, (100.0f + md.sell * -100.0f) / 100.0f);
        } else {
            for (ItemStack stack : this.baseItems.keySet()) {
                this.sellItems.put(stack, this.baseItems.get(stack));
            }
        }
        if (!this.sellItems.isEmpty() && this.sellItems.size() <= this.baseItems.size() && this.sellMoney > 0L) {
            int bc = 0;
            int sc = 0;
            for (int c : this.baseItems.values()) {
                bc += c;
            }
            for (int c : this.sellItems.values()) {
                sc += c;
            }
            float coff = 1.0f;
            if (md.sell != 0.0f) {
                coff = (100.0f + md.sell * -100.0f) / 100.0f;
            }
            if (sc <= this.sellItems.size() || (float)bc * coff < (float)sc) {
                this.sellItems.clear();
            }
        }
    }
}

